#########################################################################################################
# Analysis for the paper  - Factors Affecting User's Behavioral Intention and Use of a Mobile-Phone-
# Delivered Cognitive Behavioral Therapy for Insomnia: a Small-Scale UTAUT Analysis -
# Section: Data Characteristics
# Additional File Description Analysis of Data
# 1 Description Analysis of Preprocessed Data
# 2018 TUDelft
# Output file "description_beforeimputation.txt" will be created 
#
# required datafiles
# - 89_beforeimputation.sav
#########################################################################################################

#adjust this to folder that contain data files
setwd("/Users/Siska/Documents/temp-berkas/my work/Corine's paper/BMC/stat/")

########### libraries
library(foreign)
library(MASS)
library(psych)
###########

################################################# Data ##########################################################################
d89=read.spss("Acceptance research/smartpls scripts, data & results/Data/89_beforeImputation.sav", to.data.frame=TRUE, use.value.labels = FALSE, reencode=NA)

# direct output to a file 
sink("Acceptance research/r results/description_beforeimputation.txt", append=FALSE, split=FALSE)

# data fields
# PPnr: Participant number
# conditie: Trial condition, 0 <- waiting list, 1 <- app 
# Performance Expectancy:
# PE1	The SleepCare app provides me information about sleep
# PE2	I feel relax assisting by the SleepCare app
# PE3	The SleepCare app helps me to sleep better
# PE4	The SleepCare app provides me clear insight about my sleep pattern
# PE5	The SleepCare app provides me enough controls over my own intervention
# PE6	Using the SleepCare app, I can do the exercises independently and stay anonymous 
# PE7	The SleepCare app fits my personality
#
# Effort Expectancy:
# EE1	The use of the SleepCare app gives me no ambiguities
# EE2	The SleepCare app is easy to use
# EE3	Learning to work with the SleepCare app is easy for me
# EE4	Utilizing the app gives me little trouble
# EE5_R	Using the SleepCare app is too complicated so I find it hard to understand
# EE6	The app fits in with my daily life
#
# Social Influence
# SI1	I think that my friends would recommend me to use the SleepCare app
# SI2	I think that my family would think I should use the SleepCare app
# SI3	I think that the people in my work environment would encourage me to use the SleepCare app
# SI4	I think that other people with sleep problems would encourage me to use the SleepCare app
# SI5_R	I think that my surrounding would think negatively to a person who use the SleepCare app 
#
# Self_Efficacy
# SE1	I can work well with the SleepCare app without help from others
# SE2	I will be able to use the SleepCare app as long as nothing abnormal happens
# SE3	I can work independently with the SleepCare app
# SE4	I am sure that I'm using the SleepCare app in a good way
#
# Trust
# TR1	I trust the information that SleepCare app provides me with
# TR2_R	I think the SleepCare app will put my privacy at risk
# TR3	I am confident that the SleepCare app will work well
#
# Hedonic Motivation
# HM1	Using the SleepCare app is a good idea
# HM2_R	I hate using the SleepCare app
# HM3	I find that using the SleepCare app is fun
# HM4	I find that using the SleepCare app is interesting
# HM5	The SleepCare app gives me the feeling that my problem is taken seriously
# HM6	The approach of the SleepCare app makes me feel safe
# HM7_R	I feel apprehensive when using the SleepCare app
#
# Anxiety
# AN1_R	I'm worried about using the app
# AN2_R	I'm sometime afraid of losing information if I press a wrong button 
# AN3_R	I'm afraid to make mistakes in the SleepCare app that I cannot turn them back
# AN4_R	I feel somewhat intimidated by the SleepCare app 
#
# Behavioral Intention
# BI1	I will definitely finish the training
# BI2	I will definitely fill in the sleep diary everyday
# BI3	I will definitely do the relaxation exercise everyday
# BI4	I will certainly stay compliant to the bedtimes that I have agreed with the coach
# BI5	I am going to follow up on the sleep tips
# BI6	I am going to fill in my sleep_times in the sleep diary as well as possible
# BI7	I am going to take the time to do the relaxation exercise everyday 
#
# Facilitating Condition
# FC1	I have enough knowledge necessary for using the SleepCare app
# FC2	My mobile phone works perfectly for running the SleepCare app
# FC3	Where necessary, the SleepCare team will help me to use the SleepCare app
# FC4	Where necessary, my friends and/or family will help me to use the SleepCare app
#
# Experienced Therapy Outcome Questionnaire
# TO1_R	Because of the SleepCare app, the number of minutes that I lie awake at night is [less .. more]
# TO2	The SleepCare app provides [less .. more] insight about my sleep behavior
# TO3	Because of the SleepCare app, my bed_times are [shorter .. longer]
# TO4_R	Because of the SleepCare app, my tiredness during the day is [less .. more]
# TO5_R	Because of the SleepCare app, the amount of concerns that I experience when I go to sleep is [less .. more] 
# TO6	Because of the SleepCare app, my knowledge about sleep is [worst .. better]
# TO7	Because of the SleepCare app, the quality of my sleep is [worst .. better]
# TO8_R	Because of the SleepCare app, the time it takes to fall asleep is [less .. more]
# TO9_R	Because of the SleepCare app, the amount of times that I wake up too early in the morning and cannot go back to sleep is [less .. more]
#
# Insomnia Severity Index (ISI)
# ISI1	Please rate the current (at the last 2 weeks) severity of your insomnia problems: Difficulty failing asleep [None .. Severe]
# ISI2	Please rate the current (at the last 2 weeks) severity of your insomnia problems: Difficulty staying asleep [None .. Severe]
# ISI3	Please rate the current (at the last 2 weeks) severity of your insomnia problems: Problem waking up too early [None .. Severe]
# ISI4	How satisfied are you with your current sleep pattern? [Very satisfied .. Very dissatisfied]
# ISI5	How noticeable to others do you think your sleep problem is in terms of impairing the quality of your life? [Not at all noticeable .. Very much noticeable]
# ISI6	How worried/distressed are you about your current sleep problem [Not at all worried .. Very much worried]
# ISI7	To what extend do you consider your sleep problem to interfere with your daily functioning (e.g. daytime fatigue, mood, ability to function at work/daily chores, concentration, memory, mood, etc.) currently? [Not at all interfering .. Very much interfering]
#
# User Behavioral Data:
# SD_DO	The number of days a participant entered the sleep diary
# CONV_DO The number of completed conversations
# RE_DO	The number of days the participant completed one or more relaxation exercise
# SR_DO	The number of weeks in which a participant agreed to do the sleep restriction exercises 
# SR_DEV The mean absolute deviation between agreed and actual time in bed (in minutes)

cat("\n DESCRIPTION DATA BEFORE IMPUTATION (n=89)\n\n")
describe(d89, na.rm = TRUE, interp=FALSE, skew = FALSE, ranges = TRUE, trim=.2)

cat("\n OUTLIER of the SLEEP APP ACCEPTANCE QUESTIONNAIRE \n")
na_89<-c(sum(is.na(d89$BI1)),sum(is.na(d89$BI2)),sum(is.na(d89$BI3)),sum(is.na(d89$BI4)),sum(is.na(d89$BI5)),sum(is.na(d89$BI6)),sum(is.na(d89$BI7)),
         sum(is.na(d89$PE1)),sum(is.na(d89$PE2)),sum(is.na(d89$PE3)),sum(is.na(d89$PE4)),sum(is.na(d89$PE5)),sum(is.na(d89$PE6)),sum(is.na(d89$PE7)),
         sum(is.na(d89$EE1)),sum(is.na(d89$EE2)),sum(is.na(d89$EE3)),sum(is.na(d89$EE4)),sum(is.na(d89$EE5_R)),sum(is.na(d89$EE6)),
         sum(is.na(d89$SI1)),sum(is.na(d89$SI2)),sum(is.na(d89$SI3)),sum(is.na(d89$SI4)),sum(is.na(d89$SI5_R)),
         sum(is.na(d89$SE1)),sum(is.na(d89$SE2)),sum(is.na(d89$SE3)),sum(is.na(d89$SE4)),
         sum(is.na(d89$TR1)),sum(is.na(d89$TR2_R)),sum(is.na(d89$TR3)),
         sum(is.na(d89$HM1)),sum(is.na(d89$HM2_R)),sum(is.na(d89$HM3)),sum(is.na(d89$HM4)),sum(is.na(d89$HM5)),sum(is.na(d89$HM6)),sum(is.na(d89$HM7_R)),
         sum(is.na(d89$AN1_R)),sum(is.na(d89$AN2_R)),sum(is.na(d89$AN3_R)),sum(is.na(d89$AN4_R)),
         sum(is.na(d89$FC1)),sum(is.na(d89$FC2)),sum(is.na(d89$FC3)),sum(is.na(d89$FC4)))
na_89<-sort(na_89)
cat("   Outlier criteria SAAQ, NA more than Q3+1.5*IQR = ")
quantile(na_89,0.75) +1.5*IQR(na_89)
cat("   Outlier SAAQ indicators = BI4, SI3, HM6, SE2, FC3 and FC4 \n")

cat("\n\n################ End of Data Description before imputation ################### \n")
######### stop redirecting output.
sink()